% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsim.r
\name{brsim}
\alias{brsim}
\title{Brainerd-Robinson similarity coefficient matrix calculation, with permutation-based p-values and optional clustering}
\usage{
brsim(
  df,
  num.perm = 1000,
  clust = FALSE,
  part = NULL,
  aggl.meth = "ward.D2",
  oneplot = TRUE,
  cex.dndr.lab = 0.7,
  cex.sil.lab = 0.7,
  cex.dot.plt.lab = 0.75
)
}
\arguments{
\item{df}{A table (dataframe format) where each row represents an assemblage and each column represents an item.}

\item{num.perm}{A numeric value indicating the number of permutations to perform in each test (default is 1000).}

\item{clust}{TRUE (default) or FALSE if the user does or does not want a agglomerative hierarchical clustering to be performed.}

\item{part}{Desired number of clusters; if NULL (default), an optimal partition is calculated (see Details).}

\item{aggl.meth}{Agglomeration method ("ward.D2" by default).}

\item{oneplot}{TRUE (default) or FALSE if the user wants or does not want the plots to be visualized in a single window.}

\item{cex.dndr.lab}{Set the size of the labels used in the dendrogram.}

\item{cex.sil.lab}{Set the size of the labels used in the silhouette plot.}

\item{cex.dot.plt.lab}{Set the size of the labels used in the Cleveland's dotplots representing by-cluster proportions.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{BR.similarity.matrix: }{similarity matrix reporting the BR coefficients}
 \item{P-value.matrix: }{matrix reporting the permuted p-values}
 \item{classified.P-values.matrix: }{matrix reporting the permuted p-value classified as <0.05, <0.01, <0.001, or not significant}
 \item{BR.distance_matrix: }{distance matrix on which the hierarchical clustering is performed (returned if clustering is selected)}
 \item{avr.silh.width.by.n.of.clusters: }{average silhouette width by number of clusters (returned if clustering is selected)}
 \item{partition.silh.data: }{silhouette data for the selected partition (returned if clustering is selected)}
 \item{data.with.cluster.membership: }{copy of the input data table with an additional column storing the cluster membership for each row (returned if clustering is selected)}
 \item{by.cluster.proportion: }{table reporting the proportion of column categories across each cluster; rows sum to 100 percent (returned if clustering is selected)}
}
}
\description{
This function calculates the Brainerd-Robinson (BR) similarity coefficient for each pair of row of the input table.
It also performs a permutation test to assess the significance of each BR coefficient, and allows to carry
out a hierarchical agglomerative clustering. An optimal cluster solution can be established using the silhouette method
(see details provided below). The function produces a correlation matrix in tabular form, which is also visually plotted as an heatmap.
In the heat-map (which is built using the \code{corrplot}), the size and the color of the
squares are proportional to the Brainerd-Robinson coefficients.\cr
}
\details{
\strong{Permutation-based p-values}\cr

The rationale behind the p-value calculation is as follows: for each pair of assemblages in the input data,
the function first calculates the observed Brainerd-Robinson (BR) coefficient. This is a measure of the similarity
between the two assemblages. The function then performs a certain number of permutations (default is 1000).
In each permutation, it generates two new assemblages (each featuring a sample size corresponding to the size of
each assemblage being compared) by randomly sampling from the global pool (the combined data of all assemblages),
and calculates the BR coefficient for this new pair of assemblages. This creates a distribution of BR coefficients
that we would expect to see by chance. The p-value is then calculated as the proportion of the permuted BR coefficients
that are less than or equal to the observed BR coefficient. A small p-value (typically < 0.05) suggests that the
observed similarity between the two assemblages is statistically significant; it is unlikely to have occurred
just by chance.\cr

In simple terms, the p-value calculation is trying to answer the question: if there were no real
similarity between these two assemblages, what is the probability that I would observe a similarity as extreme as
(or more extreme than) the one I actually observed, just by chance?\cr

The p-values are returned in two matrices: in the first, the p-values are reported as they are, whereas in the second
they are classified as <0.05, <0.01, <0.001, or not significant.\cr

\strong{Hierarchical agglomerative clustering}\cr

By setting the parameter \code{clust} to \code{TRUE}, the units (rows) for which the BR coefficients have been
calculated will be clustered. Note that the clustering is based on a dissimilarity matrix which
is internally calculated as the maximum value of the BR coefficient (200) minus the observed BR coefficient.
This allows a simpler reading of the dendrogram which is produced by the function, where the less dissimilar
(i.e., more similar) units will be placed at lower levels, while more dissimilar (i.e., less similar) units
will be placed at higher levels within the dendrogram. The latter depicts the hierarchical clustering based
(by default) on the Ward's agglomeration method; rectangles identify the selected cluster partition.\cr

\strong{Number of clusters and silhouette method}\cr

Besides the dendrogram, a silhouette plot is produced, which allows to measure how 'good' is the selected cluster solution.
If the parameter \code{part} is left empty (default), an optimal cluster solution is
obtained. The optimal partition is selected via an iterative procedure which identifies at which
cluster solution the highest average silhouette width is achieved. If a user-defined partition is
needed, the user can input the desired number of clusters using the parameter \code{part}. In either
case, an additional plot is returned besides the cluster dendrogram and the silhouette plot; it
displays a scatterplot in which the cluster solution (x-axis) is plotted against the average
silhouette width (y-axis). A black dot represents the partition selected either by the iterative
procedure or by the user. Note that in the silhouette plot, the labels on the left-hand side of the
chart show the units' names and the cluster number to which each unit is closer.\cr

The silhouette plot is obtained from the \code{silhouette()} function out from the \code{cluster} package.
For a detailed description of the silhouette plot, its rationale, and its interpretation, see:\cr
Rousseeuw P J. 1987. "Silhouettes: A graphical aid to the interpretation and validation of cluster
analysis", Journal of Computational and Applied Mathematics 20, 53-65
(http://www.sciencedirect.com/science/article/pii/0377042787901257).\cr

\strong{Descriptive by-cluster dotplots}\cr

The function also provides a Cleveland's dotplots that represent by-cluster proportions. The
clustered units are grouped according to their cluster membership, the frequencies are summed, and
then expressed as percentages. The latter are represented by the dotplots, along with the average
percentage. The latter provides a frame of reference to understand which percentage is below,
above, or close to the average. The raw data on which the plots are based are stored in the
list returned by the function (see below).\cr
}
\examples{
# build a toy dataset (subset of the 'Nelson' dataset out of the 'archdata' package )

mytable <- structure(list(Biscuit = c(10, 17, 2, 10, 2, 1),
Type_I = c(2,2, 10, 40, 118, 107),
Type_II_Red = c(24, 64, 68, 91, 45, 3),
Type_II_Yellow = c(23, 90, 18, 20, 1, 0),
Type_II_Gray = c(34,76, 48, 15, 5, 0)),
row.names = c("1", "2", "3", "7", "8", "9"),
class = "data.frame")

# run the function and store the results in the 'result' object

result <- brsim(mytable, clust=TRUE)

# same as above, but with an user-defined cluster partition

result <- brsim(mytable, clust=TRUE, part=3)

}
\seealso{
\code{\link[corrplot]{corrplot}} , \code{\link[cluster]{silhouette}}
}
\keyword{similarity}
