% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_model.R
\name{update_model.bgmfit}
\alias{update_model.bgmfit}
\alias{update_model}
\title{Update model}
\usage{
\method{update_model}{bgmfit}(model, newdata = NULL, recompile = NULL, ...)

update_model(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{newdata}{An optional \code{data.frame} to be used when updating the
model. If \code{NULL} (default), the same data used in the original model
fit is evaluated. Note that data-dependent default priors will not be
updated automatically.}

\item{recompile}{A logical to indicate whether the Stan model should be
recompiled. When \code{NULL} (the default), \code{bsitar::update_model()}
tries to figure out internally, if recompilation is necessary. Setting it
to \code{FALSE} will cause all Stan code changing arguments to be ignored.}

\item{...}{Other arguments passed to \code{\link{brms}}.}
}
\value{
An updated model of class \code{brmsfit}, that contains the
posterior draws and other useful information about the model.
}
\description{
The \strong{update_model()} re fits the model of class
\code{bgmfit} by user specified new updated arguments.
}
\details{
This is an adapted version of the \strong{update()} function from
available the the\pkg{brms} package.
}
\examples{

\donttest{

# Fit Bayesian SITAR model 

# To avoid fitting the model which takes time, the model  
# fit has already been saved as 'berkeley_mfit.rda' file.
# See examples section of the main function for details on the model fit.

model <- berkeley_mfit

# Update model for degree of freedom. For illustration purpose and to save 
# time, the below example is run with sample_prior only. 

model2 <- update_model(model, df = 4, sample_prior = 'only')

}

}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
