% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_actor_lists.R
\name{bs_get_actor_lists}
\alias{bs_get_actor_lists}
\title{Get a list of lists that belong to an actor.}
\usage{
bs_get_actor_lists(
  actor,
  limit = NULL,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{actor}{Character, length 1. name of 1 actor, such as \code{'chriskenny.bsky.social'}}

\item{limit}{Integer. Maximum number to request. Maximum: \code{100}}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of lists
}
\description{
Get a list of lists that belong to an actor.
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/getLists.json}{graph/getLists.json (2023-10-02)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-02)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_actor_lists('chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{graph}
