% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal.R
\name{bs_modal}
\alias{bs_modal}
\alias{bs_modal_closebutton}
\alias{bs_attach_modal}
\title{Modal window}
\usage{
bs_modal(
  id,
  title,
  body,
  footer = bs_modal_closebutton(label = "Close"),
  size = c("medium", "large", "small")
)

bs_modal_closebutton(label = "Close", title)

bs_attach_modal(tag, id_modal)
}
\arguments{
\item{id}{character, unique id for the modal window}

\item{title}{character, title for the modal window (this argument is deprecated
for \code{bs_modal_closebutton}, use \code{label} instead)}

\item{body}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
content for the body of the modal window}

\item{footer}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
content for the footer of the modal window}

\item{size}{character, size of the modal window}

\item{label}{character (HTML), label for the close-button}

\item{tag}{\verb{htmltools::[tag][htmltools::tag]},
button or link to which to attach the modal window}

\item{id_modal}{character, unique id of modal window to attach}
}
\value{
\describe{
\item{\code{bs_modal()}}{\verb{htmltools::[tag][htmltools::tag]}, \verb{<div/>}}
\item{\code{bs_attach_modal()}}{\verb{htmltools::[tag][htmltools::tag]},
modified copy of \code{tag}}
\item{\code{bs_modal_closebutton()}}{\verb{htmltools::[tag][htmltools::tag]}, \verb{<button/>}}
}
}
\description{
Modal windows are useful to make detailed explanations, and
are typically attached to buttons or links. Thus,
there are two parts to this system:
}
\details{
\enumerate{
\item{A modal window, created using \code{bs_modal()}}
\item{At least one button or link to which the \code{id} of the
modal window is attached, using \code{bs_attach_modal()}}
}

The verb \emph{attach} is used to signify that we are attaching the \code{id} of our
modal window to the \code{tag} in question (generally a button or a link). This implies that
you can attach the \code{id} of a modal window to more than one button or link.

It is your responsibility to ensure that \code{id} is unique
among HTML elements in your page. If you have non-unique \code{id}'s, strange things may
happen to your page.

Your code may be cleaner if you can import the content for the modal body from
an external source. Here, the function \verb{shiny::[includeMarkdown][shiny::includeMarkdown]}
be useful.

If you want to compose your own footer for the modal window, the function
\code{bs_modal_closebutton()} can be useful.
}
\examples{
library("htmltools") # also needs `markdown` package
library("shiny")

bs_modal(id = "modal", title = "I'm a modal", body = "Yes, I am.")
bs_button("Click for modal") \%>\%
  bs_attach_modal(id_modal = "modal")

bs_modal(
  id = "modal_large",
  title = "I'm a modal",
  size = "large",
  body = includeMarkdown(system.file("markdown", "modal.md", package = "bsplus"))
)
bs_button("Click for modal") \%>\%
  bs_attach_modal(id_modal = "modal_large")

}
\seealso{
\verb{shiny::[includeMarkdown][shiny::includeMarkdown]}
}
