% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nightingaleTemplates}
\alias{nightingaleTemplates}
\alias{ntngale225}
\alias{ntngale249}
\title{Nightingale Health Metabolomics Plot Template Format}
\format{
Data frame with 228/249 rows and 5 variables
\describe{
\item{trait}{trait identifier as used in China Kadoorie Biobank, can be
used to merge template with results data}
\item{traitTitle}{trait description to assist with merging results}
\item{rowName}{row label for trait in plot matrix}
\item{colName}{column label for trait in plot matrix}
\item{plotGroup}{this variable splits the traits into 10 plot matrices that
make up the overall figure}
}

An object of class \code{data.frame} with 249 rows and 6 columns.
}
\usage{
ntngale225

ntngale249
}
\description{
Template datasets containing grouping and labeling variables to
information to plot 225 or 249 variable Nightingale Health metabolomics data.
}
\details{
Nightingale Health is a Finnish company which has developed a fully
automated platform for deriving over 200 quantitative metabolomics measures
from a single blood serum sample using NMR technology, at a comparable cost
to standard lipid clinical chemistry. These measures include concentration
and composition of 14 lipoprotein subclasses, apolipoproteins, fatty acids,
amino acids and glycolysis related metabolites. Over 1M samples have already
been processed, including biobank participants, population cohorts and
clinical studies, with capacity to process an additional 250K samples per
year. Over 100K profiles of UK Biobank participants have recently been
released, with data on the remaining individuals to follow. The wide
availability of standardised Nightingale datasets in global cohorts
facilitates collaborative research and is contributing to the identification
of new biomarkers across a range of diseases.
}
\keyword{datasets}
