\name{robust.summary}
\alias{robust.summary}
\alias{summary.robustified}
\title{
Robust summary
}
\description{
Output summary information using robust or clustered robust standard errors.
}
\usage{
\method{summary}{robustified}(object, \dots)

robust.summary(x, cluster, type, omega, \dots)
}
\arguments{
  \item{object}{
An object of class \code{robustified}, usually generated by
\code{\link{robustify}}.
}
  \item{x}{
A model of class \code{lm}, \code{glm}, or any other class which
contains a \code{call} object and methods for \code{estfun} and \code{nobs}.
}
  \item{cluster}{
The variable on which to cluster (if any). If this is not specified,
unclustered robust standard errors using \code{\link[sandwich]{vcovHC}} are
used. If this is specified, clustered robust standard errors using
\code{\link{vcovCR}} are used.
}
  \item{type}{
A character string specifying the estimation type. The default is to use the
defaults for \code{\link[sandwich]{vcovHC}} or \code{\link{vcovCR}}, depending on whether
\code{cluster} is specified. For details, see \code{\link[sandwich]{vcovHC}} or \code{\link{vcovCR}}.
}
  \item{omega}{
A vector or a function depending on the arguments `residuals'
(the working residuals of the model), `diaghat' (the diagonal
of the corresponding hat matrix) and `df' (the residual
degrees of freedom). For details, see \code{\link[sandwich]{vcovHC}} or \code{\link{vcovCR}}.
}
  \item{\dots}{
Any additional arguments to be passed to \code{\link[lmtest]{coeftest}}.
}
}
\details{
Both functions provide summary output with robust (Huber-White) or
clustered robust standard errors based on \code{\link[sandwich]{vcovHC}} or
\code{\link{vcovCR}}, respectively. The \code{summary} method works on objects
where the type of the standard errors has already been set by
\code{robustify}. The \code{robust.summary} function works on
unadjusted objects. Thus, \code{robust.summary(x, ...)} is
a shorthand for \code{summary(robustify(x, ...))}.

For \code{robust.summary}, if the \code{cluster} option is specified,
clustered robust standard errors are used based on the
variance-covariance matrix from \code{\link{vcovCR}} with clustering on
\code{cluster}. If not, robust standard errors are used based on the
variance-covariance matrix from \code{\link[sandwich]{vcovHC}}.
}
\value{
  An object of class \code{summary.robustified} containing
  a \code{coefficients} object computed using
  \code{\link[lmtest]{coeftest}} and the \code{method} attribute
  specifying the type of standard errors used.
}

\seealso{
See Also \code{\link{robustify}}, \code{\link[sandwich]{vcovHC}}, \code{\link{vcovCR}} and \code{\link[lmtest]{coeftest}}.
}
\examples{
## With clustering
clotting <- data.frame(
    cl = 1:9,
    u = c(5,10,15,20,30,40,60,80,100),
    lot = c(118,58,42,35,27,25,21,19,18,
            69,35,26,21,18,16,13,12,12))
clot.model <- glm(lot ~ log(u), data = clotting, family = Gamma)
robust.summary(clot.model, cluster=cl)

## Without clustering
data(swiss)
model1 <- lm(Fertility ~ ., data = swiss)
robust.summary(model1)
model1r <- robustify(model1)
summary(model1r)
}
\keyword{ robust }% use one of  RShowDoc("KEYWORDS")
\keyword{ cluster }
\keyword{ htest }
