% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRNCustomPanel.R
\name{GRNCustomPanel}
\alias{GRNCustomPanel}
\alias{GRNCustomPanelUI}
\alias{GRNCustomPanelServer}
\title{Generate the GRN custom integration panel of the shiny app}
\usage{
GRNCustomPanelUI(id, title = "GRN with custom integration", show = TRUE)

GRNCustomPanelServer(
  id,
  expression.matrix,
  anno,
  comparison.table,
  DEresults = NULL,
  seed = 13
)
}
\arguments{
\item{id}{the input slot that will be used to access the value}

\item{title}{Name for custom panel instance}

\item{show}{whether to show the panel or not; default is TRUE; there for
compatibility with specifying panels to show}

\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples; usually preprocessed by
\code{\link{preprocessExpressionMatrix}}; a list  (of the same length as
modality) can be provided if #' \code{length(modality) > 1}}

\item{anno}{annotation data frame containing a match between the row names
of the expression.matrix (usually ENSEMBL IDs) and the gene names that
should be rendered within the app and in output files; this object is
created by \code{\link{generateShinyApp}} using the org.db specified}

\item{comparison.table}{Table linking rows of expression.matrix to custom information,
for example miRNAs or transcription factors.}

\item{DEresults}{differential expression results output from DEpanelServer;
a reactive list with slots 'DEtable' (all genes), 'DEtableSubset' (only DE genes),
'lfcThreshold' and 'pvalThreshold'}

\item{seed}{Random seed to create reproducible GRNs}
}
\value{
The UI and Server components of the shiny module, that can be used
within the UI and Server definitions of a shiny app.
}
\description{
These are the UI and server components of the GRN custom integration
panel of the shiny app. It is generated by including at least 1 row in the
custom.integration parameter of \code{\link{generateShinyApp}}.
}
