% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEsummaryFuns.R
\name{expression_heatmap}
\alias{expression_heatmap}
\title{Create heatmap of an expression matrix}
\usage{
expression_heatmap(
  expression.matrix.subset,
  top.annotation.ids = NULL,
  metadata,
  type = c("Z-score", "Log2 Expression", "Expression"),
  show.column.names = TRUE
)
}
\arguments{
\item{expression.matrix.subset}{a subset of rows from the expression matrix;
rows correspond to genes and columns correspond to samples}

\item{top.annotation.ids}{a vector of column indices denoting which columns
of the metadata should become heatmap annotations}

\item{metadata}{a data frame containing metadata for the samples contained
in the expression.matrix; must contain at minimum two columns:
the first column must contain the column names of the expression.matrix,
while the last column is assumed to contain the experimental conditions
that will be tested for differential expression; a list  (of the same
length as modality) can be provided if #' \code{length(modality) > 1}}

\item{type}{type of rescaling; one of "Expression" (defautl, does nothing),
"Log2 Expression" (returns log2(x + 1) for every value), "Mean Scaled" (each
row is scaled by its average), "Z-score" (each row is centered and scaled
to mean = 0 and sd = 1)}

\item{show.column.names}{whether to show the column names below the heatmap;
default is TRUE}
}
\value{
The heatmap as detailed in the ComplexHeatmap package.
}
\description{
This function creates a heatmap to visualise an expression matrix
}
\examples{
expression.matrix.preproc <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix_preprocessed.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500,]

metadata <- data.frame(
  srr = colnames(expression.matrix.preproc), 
  timepoint = rep(c("0h", "12h", "36h"), each = 2)
)
print(expression_heatmap(head(expression.matrix.preproc), NULL, metadata))
}
