% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_eventlog.R
\name{simple_eventlog}
\alias{simple_eventlog}
\alias{isimple_eventlog}
\title{Simple Eventlog}
\usage{
simple_eventlog(
  eventlog,
  case_id = NULL,
  activity_id = NULL,
  timestamp = NULL,
  resource_id = NULL,
  order = "auto",
  validate = TRUE
)

isimple_eventlog(eventlog)
}
\arguments{
\item{eventlog}{The data object to be used as event log. This can be a
\code{data.frame} or \code{tbl_df}.}

\item{case_id}{The case classifier of the event log.}

\item{activity_id}{The activity classifier of the event log.}

\item{timestamp}{The timestamp of the event log.}

\item{resource_id}{The resource classifier of the event log (optional).}

\item{order}{Configure how to handle sort events with equal timestamps:
auto will use the order in the original data,
alphabetical will sort the activity labels by alphabet,
sorted will assume that the data frame is already correctly sorted and has a column '.order',
providing a column name will use this column for ordering (can be numeric of character).
The latter will never overrule timestamp orderings.}

\item{validate}{When `TRUE` some basic checks are run on the contents of the event log such as that activity instances are
not connected to more than one case or activity. Using `FALSE` improves the performance by skipping those checks.}
}
\description{
A function to instantiate an object of class \code{eventlog} by specifying a
\code{data.frame} or \code{tbl_df} and the minimally required case identifier, activity identifier and timestamp
}
\examples{
\dontrun{
data <- data.frame(case = rep("A",5),
activity_id = c("A","B","C","D","E"),
timestamp = date_decimal(1:5))
simple_eventlog(data,case_id = "case",
activity_id = "activity_id",
timestamp = "timestamp")
}
}
\seealso{
\code{\link{eventlog}},\code{\link{case_id}}, \code{\link{activity_id}},
\code{\link{activity_instance_id}},\code{\link{lifecycle_id}},
 \code{\link{timestamp}}
}
