% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{life}
\alias{life}
\title{Life expectancy at birth from 1960 to 2017}
\format{A data frame with 11182 rows and 4 variables:
\describe{
  \item{Country}{The name of the country}
  \item{year}{reference year of data collection}
  \item{life}{the life expectancy at birth}
  \item{group}{a grouping variable based on 'year' but with a lower resolution; spans intervals of 4 years each}
}}
\source{
\url{https://data.worldbank.org/indicator/sp.dyn.le00.in}
}
\usage{
life
}
\description{
The data is available by the courtesy of the World Bank under Creative Commons Attribution 4.0 (CC-BY 4.0).
It includes the life expectancy at birth on nation level from 1960 to 2017. The data has been converted to
long data format, aggregates for groups of nations and missings have been deleted and a grouping variable
with a broader scope spanning 4 years each has been added. It shows, that it can be better to reduce
predictors. The model does not converge anymore after using 8 predictors and the optimal solution is
achieved with four predictors, equaling R2=.9825.
}
\examples{
\dontrun{
# data preparation
data.life <- rankByGroup(life, raw="life")
data.life <- computePowers(data.life, age="year")

#determining best suiting model by plotting series
model.life <- bestModel(data.life, raw="life")
plotPercentileSeries(data.life, model.life, end=10)

# model with four predictors seems to work best
model2.life <- bestModel(data.life, raw="life", terms=4)
}
}
\references{
The World Bank (2018). Life expectancy at birth, total (years). Data Source	World Development Indicators
available \url{https://data.worldbank.org/indicator/sp.dyn.le00.in} (date of retrieval: 01/09/2018)
}
\keyword{datasets}
\keyword{datasets,}
\keyword{expectancy,}
\keyword{life}
\keyword{series}
\keyword{time}
