% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcox.R
\name{boxcox}
\alias{boxcox}
\title{Generate box cox power function for regression model at specific age}
\usage{
boxcox(model, age, n = 250, m = 50, sd = 10)
}
\arguments{
\item{model}{The regression model}

\item{age}{The specific age}

\item{n}{Number of simulated observations, used to span a percentile range from
.5/n to (n-.5)/n with equally distanced percentiles}

\item{m}{Scale mean of norm scale (default 50)}

\item{sd}{Scale sd of norm scale (default 10)}
}
\value{
a list including the data.frame with percentiles, norm scores, fitted raw scores of the regression
model and the fitted scores of the box cox curve fitting (indicated by variable names 'BC'), as well as the
parameters for the box cox function (mean, sd, lambda) for the specified the age:
\item{median}{The median of the raw value distribution, estimated by the regression model}
\item{meanBC}{The mean of the box cox function}
\item{sdBC}{The standard deviation of the box cox function}
\item{lambdaBC}{The skewness parameter of the box cox function}
\item{age}{The age for which the power function was modeled}
\item{data}{The data frame including the generated percentiles, the according norm scores,
the fitted raw scores according to the regression model, the retrieved norm scores by the box cox transformation,
the according density and percentile}
}
\description{
Applies a curve fitting for the regression model with the Box-Cox power transformation via the
LMS method of Cole and Green (1992) at a specific age. Therefore, it simulates a data set and
applies the transformation. It iteratively determines the power transformation lambda
parameter with a precision up to 10^E-5 with a lambda value of 1 indicating normal
distribution, values between 0 and 1 representing negative skew and values above 1 positive
skewness of the distribution. The function is an optional step following the non-parametric
modeling in order to conduct a parametric fitting of the percentiles.
}
\examples{
# model sample data set
model <- bestModel(prepareData())

# fitting scores of regression model box cox power function at specific age and retrieving
# the parameters for the box cox power function
bcParameters <- boxcox(model, 3)
}
\references{
Cole, T. J., & Green, P. J. (1992). Smoothing reference percentile curves: the LMS method and penalized
likelihood. Statistics in medicine, 11(10), 1305-1319.

Box, G. E., & Cox, D. R. (1964). An analysis of transformations. Journal of the Royal Statistical
Society. Series B (Methodological), 211-252.
}
\seealso{
predictNormBC, predictRawBC
}
