% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDerivative}
\alias{plotDerivative}
\title{Plot first order derivative of regression model}
\usage{
plotDerivative(
  model,
  minAge = NULL,
  maxAge = NULL,
  minNorm = NULL,
  maxNorm = NULL,
  stepAge = 0.2,
  stepNorm = 1,
  order = 1
)
}
\arguments{
\item{model}{The model from the bestModel function}

\item{minAge}{Age to start with checking}

\item{maxAge}{Upper end of the age check}

\item{minNorm}{Lower end of the norm score range, in case of T scores, 25 might be good}

\item{maxNorm}{Upper end of the norm score range, in case of T scores, 25 might be good}

\item{stepAge}{Stepping parameter for the age check, usually 1 or 0.1; lower
values indicate higher precision / closer checks}

\item{stepNorm}{Stepping parameter for norm scores}

\item{order}{Degree of the derivative (default = 1)}
}
\description{
Plots the scores obtained via the first order derivative of the regression model
in dependence of the norm score. The results indicate the progression of the
norm scores within each age group. The regression based modeling approach
relies on the assumption of a linear progression of the norm scores.
Negative scores in the first order derivative indicate a violation of this
assumption. Scores near zero
are typical for bottom and ceiling effects in the raw data.
The regression models usually converge within the range of the original
values. In case of vertical and horizontal extrapolation, with increasing
distance to the original data, the risk of assumption violation increases
as well.
ATTENTION: plotDerivative is currently still incompatible with reversed raw
score scales ('descent' option)
}
\examples{
# Load example data set, compute model and plot results
normData <- prepareData()
m <- bestModel(data = normData)
plotDerivative(m, minAge=2, maxAge=5, step=.2, minNorm=25, maxNorm=75, stepNorm=1)
}
\seealso{
checkConsistency, bestModel, derive
}
