% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{predictBeta}
\alias{predictBeta}
\title{Predicts beta coefficients in dependence of age}
\usage{
predictBeta(model, x, group)
}
\arguments{
\item{model}{An `betaContinuous` model output}

\item{x}{A vector specifying the raw scores}

\item{group}{A vector specifying the group variables for each raw score}
}
\value{
A data.frame with z scores and percentiles as well as predicted a and b values for the specific group
}
\description{
Predicts beta coefficients in dependence of age
}
\examples{
# Determies beta parameters and models these continuously
param <- betaByGroup(elfe$raw, elfe$group, 26)
beta.model <- betaContinuous(param, 4, 4)

# Calculates z scores
x <- c(15, 8, 11, 18)
newGroup <- c(3.9, 1.2, 4.5, 6.3)

predictBeta(beta.model, x, newGroup)
}
