% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_tf}
\alias{get_tf}
\title{Get transcription factor correlations from cRegulome.db}
\usage{
get_tf(conn, tf, study, min_abs_cor, max_num, targets_only = FALSE, targets)
}
\arguments{
\item{conn}{A connection such as this returned by 
\code{\link[DBI]{dbConnect}}}

\item{tf}{A required \code{character} vector of the transcription factor of
interest. These are the HUGO official gene symbols of the genes contains the
transcription factor.}

\item{study}{A \code{character} vector of The Cancer Genome Atlas (TCGA)
study identifiers. To view the available studies in TCGA project,
\url{https://tcga-data.nci.nih.gov/docs/publications/tcga}. When left to
default \code{NULL} all available studies will be included.}

\item{min_abs_cor}{A \code{numeric}, an absolute correlation minimum between 0
and 1 for each \code{mir}.}

\item{max_num}{An \code{integer}, maximum number of \code{features} to show
for each \code{mir} in each \code{study}.}

\item{targets_only}{A \code{logical} whether restrict the output to 
the recognized target features.}

\item{targets}{A \code{character} vector of gene symbol names.}
}
\value{
A tidy \code{data.frame} of four columns. \code{tf} is the official
gene symbols of the genes contains the transcription factor, \code{feature}
is the features/genes, cor is the corresponding expression correlations
and \code{study} is TCGA study ID.
}
\description{
This function access the \code{sqlite} database file which is obtained by
running \link{get_db}. Basically, the function provides ways to query the 
database to the correlation data of the transcription factors of interest. 
The function returns an error if the database file \code{cRegulome.db} is 
not in the working directory.
}
\examples{
# locate the testset file and connect
fl <- system.file('extdata', 'cRegulome.db', package = 'cRegulome')
conn <- RSQLite::dbConnect(RSQLite::SQLite(), fl)

\dontrun{
# get transcription factors correlations in all studies
get_tf(conn,
        tf = 'LEF1')
}

# get correlations in a particular study
get_tf(conn,
       tf = 'LEF1',
       study = 'STES')

# enter a custom query with different arguments
get_tf(conn,
       tf = 'LEF1',
       study = 'STES',
       min_abs_cor = .3,
       max_num = 5)

}
