% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-normal.R
\name{str_normal}
\alias{str_normal}
\title{Normalize a character string}
\usage{
str_normal(x, case = TRUE, punct = "", quote = TRUE, squish = TRUE)
}
\arguments{
\item{x}{A character string to normalize.}

\item{case}{logical; whether \code{\link[stringr:case]{stringr::str_to_upper()}} should be called.}

\item{punct}{character; A character string to replace most punctuation with.}

\item{quote}{logical; whether \code{\link[stringr:str_replace]{stringr::str_replace_all()}} should be called
on double quotes.}

\item{squish}{logical; whether \code{\link[stringr:str_trim]{stringr::str_squish()}} should be called.}
}
\value{
A normalized vector of the same length.
}
\description{
The generic normalization that underpins functions like \code{\link[=normal_city]{normal_city()}} and
\code{\link[=normal_address]{normal_address()}}. This function simply chains together three
\verb{stringr::str_*()} functions:
\enumerate{
\item Convert to uppercase.
\item Replace punctuation with whitespaces.
\item Trim and squish excess whitespace.
}
}
\examples{
str_normal("   TestING 123   example_test.String   ")
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()}
}
\concept{geographic normalization functions}
