% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpr_classify_signif.R
\name{cpr_classify_signif}
\alias{cpr_classify_signif}
\title{Classify statistical significance}
\usage{
cpr_classify_signif(df, metric, one_sided = FALSE, upper = FALSE)
}
\arguments{
\item{df}{Input data frame.}

\item{metric}{Character vector of length 1; selected metric to classify
significance. May choose from \code{pd} (phylogenetic diversity), \code{rpd}
(relative phylogenetic diversity), \code{pe} (phylogenetic endemism), \code{rpe}
(relative phylogenetic endemism) (case-sensitive).}

\item{one_sided}{Logical vector of length 1; is the null hypothesis
one-sided? If \code{TRUE}, values will be classified as significant if they are
in \strong{either} the top 5\% \strong{or} bottom 5\%. If \code{FALSE}, values will be
classified as significant if they are in the top 2.5\% or bottom 2.5\%,
combined.}

\item{upper}{Logical vector of length 1; only applies if \code{one_sided} is
\code{TRUE}. If \code{TRUE}, values in the top 5\% will be classified as significant.
If \code{FALSE}, values in the bottom 5\% will be classified as significant.}
}
\value{
Object of class data.frame with column added for statistical
significance of the selected metric. The new column name is the name of the
metric with \verb{_signif} appended. The new column is a character that may
contain the following values, depending on the null hypothesis:
\itemize{
\item \verb{< 0.01}, \verb{< 0.025}, \verb{> 0.975}, \verb{> 0.99}, \verb{not significant} (two-sided)
\item \verb{< 0.01}, \verb{< 0.05}, \verb{> 0.99}, \verb{> 0.95}, \verb{not significant} (one-sided)
}
}
\description{
Given the results of \code{\link[=cpr_rand_test]{cpr_rand_test()}}, classifies statistical significance
of a biodiversity metric. The null hypothesis is that observed value does not
lie in the extreme of the random values.
}
\details{
For metrics like \code{pe}, you probably want to consider a one-sided
hypothesis testing values in the upper extreme (i.e., we are interested in
areas that have higher than expected endemism). For this, you would set
\verb{one_sided = TRUE, upper = TRUE}. For metrics like \code{pd}, you probably want
to consider a two-sided hypothesis (i.e., we are interested in areas that
are either more diverse or less than diverse than expected at random). For
this, set \code{one_sided = FALSE}.
}
\examples{
\donttest{
set.seed(12345)
data(phylocom)
rand_test <- cpr_rand_test(
  phylocom$comm, phylocom$phy,
  null_model = "curveball", metrics = "pd", n_reps = 50
)
cpr_classify_signif(rand_test, "pd")
}
}
