% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim.R
\name{get_cansim_column_categories}
\alias{get_cansim_column_categories}
\title{Retrieve Statistics Canada data table categories for a specific column}
\usage{
get_cansim_column_categories(
  cansimTableNumber,
  column,
  language = "english",
  refresh = FALSE,
  timeout = 200
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{column}{the specified column for which to retrieve category information for}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (default set to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}
}
\description{
Returns table column details given an NDM table number in English or French. Retrieved table information data is cached for the duration of the R session only.
}
\examples{
get_cansim_column_categories("34-10-0013", "Geography")

}
