% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_parquet.R
\name{cansim_repartition_cached_table}
\alias{cansim_repartition_cached_table}
\title{Repartitions a cached cansim table to a new partitioning scheme}
\usage{
cansim_repartition_cached_table(
  cansimTableNumber,
  new_partitioning = c(),
  language = "english",
  format = "parquet",
  cache_path = getOption("cansim.cache_path")
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{new_partitioning}{(Optional) Partition columns to use for parquet or feather formats.}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (defaults to English)}

\item{format}{(Optional) The format of the data table to retrieve. Either \code{"parquet"}, \code{"feather"}, or \code{sqlite} (default is \code{"parquet"}).}

\item{cache_path}{(Optional) Path to where to cache the table permanently. By default, the data is cached
in the path specified by `getOption("cansim.cache_path")`, if this is set. Otherwise it will use `tempdir()`.}
}
\description{
Repartitions and already downloaded and cached parquet or feather dataset
}
\examples{
\dontrun{
cansim_repartition_cached_table("34-10-0013",new_partitioning=c("GeoUID"))

}
}
