% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors_from_values.R
\name{colors_from_values}
\alias{colors_from_values}
\title{Retrieve colors based on numeric values}
\usage{
colors_from_values(
  vals,
  split_at_vals = FALSE,
  split_points = 0,
  col_scale = c("green", "purple", "orange", "blue", "brown", "gray"),
  light_dark = "f",
  grad_dir = c("high", "low", "middle", "ends"),
  color_fun = c("linear", "exponential"),
  exp_steepness = 1,
  global_color_scale = FALSE,
  global_min = NULL,
  global_max = NULL,
  use_pheatmap_colors = FALSE,
  na_col = "lightgray"
)
}
\arguments{
\item{vals}{A vector of numerical values for which to
retrieve colors.}

\item{split_at_vals}{A logical value indicating whether
the numbers should be broken into classes with different 
colors.}

\item{split_points}{If split_at_vals is TRUE, split_points
is used to define multiple classes of numbers. For example,
if split_points is 0, negative numbers will be assigned one
class of colors, and positive numbers will be assigned another.}

\item{col_scale}{One of c("green", "purple", "orange", "blue", 
"brown", "gray") to indicate the color scale to be used. Defaults
to gray.}

\item{light_dark}{One of "l", "d", or "f" indicating whether
the colors used should be light ("l"), dark ("d"), or from
across the full spectrum ("f").}

\item{grad_dir}{A string specifying how the color gradient 
should be applied. If "high" higher values are given darker
colors. If "low", lower values are given darker colors.
If "middle" values in the middle of the spectrum are 
given darker colors, and if "end" values at the ends
of the spectrum are given darker colors.}

\item{color_fun}{Either "linear" or "exponential" indicating
how the colors should transition from light to dark across
values.}

\item{exp_steepness}{If color_fun is "exponential," exp_steepness
indicates how quickly the colors should transition from light 
to dark.}

\item{global_color_scale}{Whether to impose a global minimum
and maximum to the colors, or to use the values themselves to 
determine the top and bottom of the color scale.}

\item{global_min}{If global_color_scale is TRUE, the minimum
value that should be assigned a color.}

\item{global_max}{If global_color_scale is TRUE, the maximum
value that should be assigned a color.}

\item{use_pheatmap_colors}{If TRUE, all other color parameters
are ignored, and colors like those used in the R package
pheatmap are used instead.}

\item{na_col}{The color to use for missing values.}
}
\value{
A vector of colors assigned to the number is vals is returned.
}
\description{
This function gets colors for numeric values
It can use one the function \code{\link{get_color}},
which accepts any of c("green", "purple", "orange", 
"blue", "brown", "gray"), or it can use pheatmap
colors.
The colors can be split into multiple classes based
on split_points. For example positive and negative 
numbers can each be plotted on their own scale, by 
setting split_at_vals to TRUE and setting split_points
to 0. split_points can be a vector defining multiple 
value classes for different colors. By default, the
different classes use the col_scale colors in order.
Specific colors for classes can be set using the 
col_scale argument.
}
\references{
Raivo Kolde (2019). pheatmap: Pretty Heatmaps. 
R package version 1.0.12. https://CRAN.R-project.org/package=pheatmap
}
\keyword{internal}
