% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_pie.R
\name{draw_pie}
\alias{draw_pie}
\title{Draw a pie chart}
\usage{
draw_pie(
  x = 0.5,
  y = 0.5,
  radius = 1,
  cols = c("red", "green"),
  border_col = "black",
  node_border_lwd = 1,
  labels = NULL,
  edges = 200,
  label_cex = 1,
  xlim = NULL,
  ylim = NULL,
  add = TRUE
)
}
\arguments{
\item{x}{the x coordinate for the center of the pie chart}

\item{y}{the y coordinate for the center of the pie chart}

\item{radius}{The radius of the pie chart}

\item{cols}{A vector of colors in any format specifying the colors 
of the sections of the pie chart. The number of colors determines
the number of sections in the pie.}

\item{border_col}{The color of the border of the pie chart. Use NA
to omit the border.}

\item{node_border_lwd}{The thickness of the border line}

\item{labels}{A vector of character values giving labels for the 
sections of the pie.}

\item{edges}{The default value is 200, which generates a circle.
Reducing this number will result in other shapes that may or may
not produce meaningful graphs depending on the number of pie sections.}

\item{label_cex}{A numeric value giving the size of the label text.}

\item{xlim}{A vector of length two giving the xlim of the plot if 
add is FALSE}

\item{ylim}{A vector of length two giving the ylim of the plot if 
add is FALSE}

\item{add}{A logical value indicating whether the pie should be 
added to an existing plot (TRUE) or drawn on a new plot (FALSE).}
}
\description{
Draw a pie graph evenly divided into polygons
each colored according to the specified colors (cols)
The center of the pie chart is at coordinates x, y
and the radius is defined by rad
}
\keyword{internal}
