% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairscan.R
\name{pairscan}
\alias{pairscan}
\title{This function performs the pairwise scan on all markers.}
\usage{
pairscan(
  data_obj,
  geno_obj = NULL,
  scan_what = c("eigentraits", "raw_traits"),
  pairscan_null_size = NULL,
  max_pair_cor = NULL,
  min_per_genotype = NULL,
  kin_obj = NULL,
  num_pairs_limit = 1e+06,
  num_perm_limit = 1e+07,
  overwrite_alert = TRUE,
  run_parallel = FALSE,
  n_cores = 4,
  verbose = FALSE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{scan_what}{A character string uniquely identifying whether eigentraits
or raw traits should be scanned. Options are "eigentraits", "raw_traits"}

\item{pairscan_null_size}{The total size of the null distribution.
This is DIFFERENT than the number of permutations to run. Each permutation
generates n choose 2 elements for the pairscan. So for example, a permutation
that tests 100 pairs of markers will generate a null distribution of size 4950.
This process is repeated until the total null size is reached. If the null size
is set to 5000, two permutations of 100 markers would be done to get to a null
distribution size of 5000.}

\item{max_pair_cor}{A numeric value between 0 and 1 indicating the maximum
Pearson correlation that two markers are allowed. If the correlation
between a pair of markers exceeds this threshold, the pair is not tested.
If this value is set to NULL, min_per_genotype must have a numeric value.}

\item{min_per_genotype}{The minimum number of individuals allowable per
genotype combination. If for a given marker pair, one of the genotype combinations is
underrepresented, the marker pair is not tested. If this value is NULL,
max_pair_cor must have a numeric value.}

\item{kin_obj}{a kinship object calculated by \code{\link{kinship}}.}

\item{num_pairs_limit}{A number indicating the maximum number of pairs to
scan. If the number of pairs exceeds this threshold, the function asks for
confirmation before proceeding with the pairwise scan.}

\item{num_perm_limit}{A number indicating the maximum number of total
permutations that will be performed. If the number of total permutations
exceeds this threshold, the function asks for confirmation before
proceeding with the pairwise scan.}

\item{overwrite_alert}{If TRUE raises a warning to users not to overwrite 
their data object with a singlescan object. A warning necessary after a 
new version of cape began separating results from different functions into
different results objects}

\item{run_parallel}{Whether to run the analysis on parallel CPUs}

\item{n_cores}{The number of CPUs to use if run_parallel is TRUE}

\item{verbose}{Whether to write progress to the screen}
}
\value{
This function returns an object assigned to pairscan_obj in 
\code{\link{run_cape}}.

The results object is a list of five elements:
ref_allele: The allele used as the reference for the tests.
max_pair_cor: The maximum pairwise correlation between marker pairs
pairscan_results: A list with one element per trait. The element for
each trait is a list of the following three elements:
   pairscan_effects: the effect sizes from the linear models
   pairscan_se: the standard errors from the linear models
   model_covariance: the model covariance from the linear models.
pairscan_perm: The same structure as pairscan_results, but for the
permuted data.
pairs_tested_perm: A matrix of the marker pairs used in the permutation
tests.
}
\description{
This function performs the pairwise regression on all selected marker pairs.
The phenotypes used can be either eigentraits or raw phenotypes. Permutation
testing is also performed.
}
\details{
Not all marker pairs are necessarily tested. Before markers are
  tested for interaction, they are checked for several conditions. Pairs are
  discarded if (1) at least one of the markers is on the X chromosome, or (2)
  there are fewer than min_per_genotype individuals in any of the genotype
  combinations.
}
\seealso{
\code{\link{select_markers_for_pairscan}}, \code{\link{plot_pairscan}}
}
