% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capitalR.R
\name{ppmt}
\alias{ppmt}
\title{Principal Payment}
\usage{
ppmt(pv, fv = 0, n, r, x, end = TRUE)
}
\arguments{
\item{pv}{Present Value}

\item{fv}{Future Value}

\item{n}{Number of Periods}

\item{r}{Rate}

\item{x}{Period in which to calculate the principal portion of the payment}

\item{end}{If FALSE, payments are made at the beginning of the period}
}
\value{
Returns the Principal Portion of the Payment in Period "x"
}
\description{
Calculates the principal of the payment in period "x"
}
\examples{
ppmt(pv  = 5000, fv = 0, n = 4 * 12, r = 0.06/12, x = 12, end = TRUE)
}
