% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trefoil.R
\name{gen_trefoil3d}
\alias{gen_trefoil3d}
\title{Generate 3-D Trefoil Knot Coordinates (Stereographic Projection)}
\usage{
gen_trefoil3d(n = 500, p = 4, steps = 5)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{steps}{A numeric value (default: 5) representing the number of steps for the theta parameter.}
}
\value{
A data containing 3-D trefoil knot.
}
\description{
This function generates coordinates for a 3-D trefoil knot
by applying a stereographic projection from 4-D space.
}
\examples{
set.seed(20240412)
trefoil3d <- gen_trefoil3d(n = 500, p = 4, steps = 5)
}
