\name{xyplot.resamples}
\alias{xyplot.resamples}
\alias{densityplot.resamples}
\alias{bwplot.resamples}
\alias{splom.resamples}
\alias{parallel.resamples}

\title{Lattice Functions for Visualizing Resampling Results}

\description{
Lattice functions for visualizing resampling results across models
}
\usage{
\method{xyplot}{resamples}(x, data = NULL, models = x$models[1:2], metric = x$metric[1], ...)

\method{densityplot}{resamples}(x, data = NULL, models = x$models, metric = x$metric, ...)

\method{bwplot}{resamples}(x, data = NULL, models = x$models, metric = x$metric, ...)

\method{splom}{resamples}(x, data = NULL, models = x$models, metric = x$metric[1], panelRange = NULL, ...)

\method{parallel}{resamples}(x, data = NULL, models = x$models, metric = x$metric[1], ...)

}
\arguments{
  \item{x}{an object generated by \code{resamples}}
  \item{data}{Not used}
  \item{models}{a character string for which models to plot. Note: \code{xyplot} requires exactly two models whereas the other methods can plot more than two.}
  \item{metric}{a character string for which metrics to use as conditioning variables in the plot. \code{splom} requires exactly one metric and does not condition.}
  \item{\dots}{further arguments to pass to either \code{\link[lattice:histogram]{histogram}}, \code{\link[lattice:histogram]{densityplot}}, \code{\link[lattice:xyplot]{xyplot}} or \code{\link[lattice:splom]{splom}}}
  \item{panelRange}{a common range for the panels. If \code{NULL}, the panel ranges are derived from the values across all the models}
}
\details{
\code{xyplot} only uses two models in the plot. The plot uses difference of the models on the y-axis and the average of the models on the x-axis.

\code{densityplot} and \code{bwplot} display univariate visualizations of the resampling distributions while \code{splom} shows the pair-wise relationships.
}
\value{
a lattice object
}

\author{Max Kuhn}

\seealso{
\code{\link{resamples}}, \code{\link[lattice:bwplot]{bwplot}}, \code{\link[lattice:histogram]{densityplot}}, \code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:splom]{splom}}
}
\examples{
\dontrun{
#load(url("http://caret.r-forge.r-project.org/Classification_and_Regression_Training_files/exampleModels.RData"))

resamps <- resamples(list(CART = rpartFit,
                          CondInfTree = ctreeFit,
                          MARS = earthFit))
bwplot(resamps,
       metric = "RMSE")

densityplot(resamps,
            auto.key = list(columns = 3),
            pch = "|")

xyplot(resamps,
       models = c("CART", "MARS"),
       metric = "RMSE")

splom(resamps, metric = "RMSE")

parallel(resamps, metric = "RMSE")


}
}

\keyword{hplot}
