% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propSymbolsChoroLayer.R
\name{propSymbolsChoroLayer}
\alias{propSymbolsChoroLayer}
\title{Proportional and Choropleth Symbols Layer}
\usage{
propSymbolsChoroLayer(x, spdf, df, spdfid = NULL, dfid = NULL, var,
  inches = 0.3, fixmax = NULL, symbols = "circle", border = "grey20",
  lwd = 1, var2, breaks = NULL, method = "quantile", nclass = NULL,
  col = NULL, colNA = "white", legend.title.cex = 0.8,
  legend.values.cex = 0.6, legend.var.pos = "right",
  legend.var.title.txt = var, legend.var.values.rnd = 0,
  legend.var.style = "c", legend.var.frame = FALSE,
  legend.var2.pos = "topright", legend.var2.title.txt = var2,
  legend.var2.values.rnd = 2, legend.var2.nodata = "no data",
  legend.var2.frame = FALSE, add = TRUE)
}
\arguments{
\item{x}{an sf object, a simple feature collection. If x is used then spdf, df, spdfid and dfid are not.}

\item{spdf}{SpatialPointsDataFrame or SpatialPolygonsDataFrame; if spdf 
is a SpatialPolygonsDataFrame symbols are plotted on centroids.}

\item{df}{a data frame that contains the values to plot. If df is missing 
spdf@data is used instead.}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}

\item{dfid}{identifier field in df, default to the first column 
of df. (optional)}

\item{var}{name of the numeric field in df to plot the symbols sizes.}

\item{inches}{size of the biggest symbol (radius for circles, width for
squares, height for bars) in inches.}

\item{fixmax}{value of the biggest symbol (see \link{propSymbolsLayer} Details).}

\item{symbols}{type of symbols, one of "circle", "square" or "bar".}

\item{border}{color of symbols borders.}

\item{lwd}{width of symbols borders.}

\item{var2}{name of the numeric field in df to plot the colors.}

\item{breaks}{break points in sorted order to indicate the intervals for assigning the colors. 
Note that if there are nlevel colors (classes) there should be (nlevel+1) 
breakpoints (see \link{choroLayer} Details).}

\item{method}{a discretization method; one of "sd", "equal", 
"quantile", "fisher-jenks", "q6" or "geom"  (see \link{choroLayer} Details).}

\item{nclass}{a targeted number of classes. If null, the number of class is 
automatically defined (see \link{choroLayer} Details).}

\item{col}{a vector of colors. Note that if breaks is specified there must be one less 
colors specified than the number of break.}

\item{colNA}{no data color.}

\item{legend.title.cex}{size of the legend title.}

\item{legend.values.cex}{size of the values in the legend.}

\item{legend.var.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)). If 
legend.var.pos is "n" then the legend is not plotted.}

\item{legend.var.title.txt}{title of the legend (proportional symbols).}

\item{legend.var.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.var.style}{either "c" or "e". The legend has two display 
styles.}

\item{legend.var.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{legend.var2.pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)). If 
legend.var2.pos is "n" then the legend is not plotted.}

\item{legend.var2.title.txt}{title of the legend (colors).}

\item{legend.var2.values.rnd}{number of decimal places of the values in 
the legend.}

\item{legend.var2.nodata}{text for "no data" values}

\item{legend.var2.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a proportional symbols layer with colors based on a 
quantitative data discretization.
}
\examples{
data("nuts2006")
## Example 1
# Growth rate
nuts0.df$cagr <- (((nuts0.df$pop2008 / nuts0.df$pop1999)^(1/9)) - 1) * 100
# Countries plot
plot(nuts0.spdf, col = "grey60",border = "grey20", add=FALSE)
# Plot the symbols
propSymbolsChoroLayer(spdf = nuts0.spdf, df = nuts0.df,symbols = "circle",
                      var = "pop2008", var2 = "cagr")

## Example 2
# Share of farmers in Martinique
mtq <- st_read(system.file("shape/martinique.shp", package="cartography"))
mtq$shareCS1 <- 100 * mtq$C13_CS1/mtq$C13_POP
plot(st_geometry(mtq), col = "grey60",border = "white", 
     lwd=0.4, bg = "lightsteelblue1")
propSymbolsChoroLayer(x = mtq, var = "C13_POP", var2 = "shareCS1", 
                      col = carto.pal(pal1 = "blue.pal", n1 = 3,
                                      pal2 = "red.pal", n2 = 3),
                      inches = 0.2, method = "q6",
                      border = "grey50", lwd = 1,
                      legend.var.pos = "topright", legend.var2.pos = "left",
                      legend.var2.title.txt = 
                        "Share of \\nthe population\\nworking in\\nagriculture (\%)",
                      legend.var.title.txt = "Population aged\\n15 and over",
                      legend.var.style = "e")

# First layout
layoutLayer(title="Farmers in Martinique, 2013",
            scale = NULL,col = NA, coltitle = "black",
            author = "INSEE, 2016", sources = "",
            frame = FALSE)
}
\seealso{
\link{legendBarsSymbols}, \link{legendChoro}, 
\link{legendCirclesSymbols}, \link{legendSquaresSymbols}, 
\link{choroLayer}, \link{propSymbolsLayer}
}
