% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial.R
\name{trial}
\alias{trial}
\title{The function \code{trial} produces traffic performance information, stored in lists \code{L} and \code{Fw}
for lead and following vehicles, respectively/
\code{L} and \code{Fw} contain the information needed to graph a time-distance \code{t-x} trajectories for two vehicles.}
\usage{
trial(ul, ubk, k, uf, d, leff, xlim, ylim)
}
\arguments{
\item{ul}{pre-breakdown speed of lead \code{l} vehicle, a number}

\item{ubk}{breakdown speed of lead \code{l} vehicle, a number}

\item{k}{traffic density  of the pre-breakdown state, a number}

\item{uf}{pre-breakdown speed  of following \code{f} vehicle, a number}

\item{d}{deceleration rate of the first of lead  \code{l} vehicle, a number}

\item{leff}{effective vehicle length (feet), a number}

\item{xlim}{plot range along the \code{t} axis, a vector}

\item{ylim}{plot range along the \code{x} axis, a vector}
}
\value{
\code{LF} consists of a list of four outputs: (1) an input vector where speed is given
in miles per hour (mph), where vehicle density is given in vehicles per mile, vpm,
where deceleration rate is given in feet per second squared (fps2), and where vehicle length in feet; (2) an
input vector using feet and second scales exclusively; a car-following matrix \code{L}; and
(4) a \code{output} vector consisting various performance estimates of delay including traffic flow in
the congested state and shock-wave speed for evaluating queuing.
}
\description{
The function \code{trial} produces traffic performance information, stored in lists \code{L} and \code{Fw}
for lead and following vehicles, respectively/
\code{L} and \code{Fw} contain the information needed to graph a time-distance \code{t-x} trajectories for two vehicles.
}
