% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIndex.R
\docType{methods}
\name{setIndex}
\alias{setIndex}
\alias{setIndex,Index-method}
\alias{setIndex,ANY-method}
\title{Set up a time index for frequency or severity.}
\usage{
setIndex(object, ...)

\S4method{setIndex}{Index}(object)
}
\arguments{
\item{object}{Index Object}

\item{...}{Additional function arguments}
}
\description{
\code{setIndex} sets a time index to reflect inflation, underwriting cycle or seasonality.
}
\examples{
xindex <- new("Index", indexID = "IDX1", tabulate = FALSE, annualizedRate = 0.03)
xindex<-setIndex(xindex)
xindex@monthlyIndex

xindex <- new("Index")
setID(xindex)<-"IDX1"
setTabulate(xindex)<-TRUE
setAnnualizedRate(xindex)<-0.03
setYearlyIndex(xindex)<- c(1,1.05,1.2,0.95,1.3)
set.seed(123)
setSeasonality(xindex)<-rnorm(12,mean=1,sd=0.03)
xindex<-setIndex(xindex)
xindex@monthlyIndex
}
