% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitDist.R
\docType{methods}
\name{setprobs<-}
\alias{setprobs<-}
\alias{setprobs<-,FitDist,vector-method}
\alias{setprobs,ANY-method}
\title{Set the percentiles to be matched. Only used when qme is chosen for fitting method.}
\usage{
setprobs(this, ...) <- value

\S4method{setprobs}{FitDist,vector}(this) <- value
}
\arguments{
\item{this}{FitDist Object}

\item{...}{Additional function arguments}

\item{value}{A numeric vector with values between 0 and 1.}
}
\description{
Set the percentiles to be matched. Only used when qme is chosen for fitting method.
}
\examples{
library(cascsim)
data(claimdata)

#frequecy fitting example
findex <- new("Index", startDate = as.Date("2012-01-01"), tabulate=TRUE, monthlyIndex = c(rep(1,11),
cumprod(c(1,rep(1.5^(1/12),11))),cumprod(c(1.5,rep((1.3/1.5)^(1/12),11))),
cumprod(c(1.3,rep((1.35/1.3)^(1/12),11))),cumprod(c(1.35,rep((1.4/1.35)^(1/12),11))),1.4))
rawdata <- as.data.frame(as.Date(claimdata[(claimdata[,"LoB"]=="Auto" & 
claimdata[,"Type"]=="H"),]$occurrenceDate))
colnames(rawdata)<-"occurrenceDate"
xFit <- new("FitDist", observation=rawdata, trend=findex,startDate = as.Date("2012-01-01"),
method="mle",ifreq=TRUE,idate=TRUE, freq="Monthly")
setprobs(xFit) <- c(0.1,0.5,0.9)
xFit@probs
}
