% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{configuracion_disenio}
\alias{configuracion_disenio}
\title{Diseño complejo para estadistica descriptiva e inferencia}
\usage{
configuracion_disenio(
  datos,
  variable = "ytotcorh",
  agrupacion = "region",
  peso = "expr",
  conglomerado = "varunit",
  estrato = "varstrat"
)
}
\arguments{
\item{datos}{un data.frame o tibble con la encuesta CASEN (o un subconjunto
acotado a una region, etc)}

\item{variable}{una columna de tipo numerico, por ejemplo ytotcorh que es la
opcion por defecto}

\item{agrupacion}{una columna de tipo texto/factor, por ejemplo region que
es la opcion por defecto}

\item{peso}{una columna de tipo numerico, por defecto es expr que corresponde
al factor de expansion regional de acuerdo al manual CASEN 2017}

\item{conglomerado}{una columna de tipo numerico, por defecto es varunit de
acuerdo al manual CASEN 2017}

\item{estrato}{una columna de tipo numerico, por defecto es varunit de
acuerdo al manual CASEN 2017}
}
\value{
Una lista con el diseño y los grupos.
}
\description{
Usa los factores de expansion, conglomerados y estratos para
definir un objeto de disenio complejo.
}
\examples{
cd <- configuracion_disenio(casen_2017_los_rios, "ytotcorh", c("comuna", "sexo"), "expc")
cd$disenio
cd$grupos
}
