% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instance.R
\name{generate_instance_roc}
\alias{generate_instance_roc}
\title{Generate data sets under realistic parameter configurations}
\usage{
generate_instance_roc(
  nrep = 10,
  n = 100,
  prev = 0.5,
  random = FALSE,
  m = 10,
  auc = "seq(0.85, 0.95, length.out = 5)",
  rhose = 0.5,
  rhosp = 0.5,
  dist = "normal",
  e = 10,
  k = 100,
  delta = 0,
  ...,
  data = NULL,
  job = NULL
)
}
\arguments{
\item{nrep}{integer, number of instances}

\item{n}{integer, total sample size}

\item{prev}{numeric, disease prevalence}

\item{random}{logical, fixed prevalence (FALSE) or simple random sampling (TRUE)}

\item{m}{integer, number of candidates}

\item{auc}{numeric}

\item{rhose}{numeric}

\item{rhosp}{numeric}

\item{dist}{character}

\item{e}{numeric}

\item{k}{numeric}

\item{delta}{numeric}

\item{...}{further arguments}

\item{data}{ignored (for batchtools compatibility)}

\item{job}{ignored (for batchtools compatibility)}
}
\value{
a list, a single (ROC) simulation instance
}
\description{
Generates a (simulation) instance, a list of multiple datasets to be processed
(analyzed) with \link{process_instance}. Ground truth parameters (Sensitvity & Specificity) are
initially generated according to a generative model whereby multiple decision rules (with
different parameter values) are derived by thresholding multiple biomarkers.
}
\details{
Utilizes same arguments as \link{draw_data_roc} unless mentioned above.
}
