\name{generate_random_tree}
\alias{generate_random_tree}
\title{
Generate a tree using a Poissonian speciation/extinction model.
}
\description{
Generate a random phylogenetic tree via simulation of a Poissonian speciation/extinction (birth/death) process. New species are added (born) by splitting of a randomly chosen extant tip. The birth and death rates of tips can each be constant or power-law functions of the number of extant tips. For example,
\deqn{
B = I + F\cdot N^E,
}
where \eqn{B} is the birth rate, \eqn{I} is the intercept, \eqn{F} is the power-law factor, \eqn{N} is the current number of extant tips and \eqn{E} is the power-law exponent. In the case of a constant birth rate (\eqn{F=0}) and zero death rate, this becomes the Yule speciation model (Aldous, 2001; Steel and McKenzie, 2001), which assumes that new species are added at a constant Poissonian rate by splitting of a random extant tip.
}
\usage{
generate_random_tree(max_tips, max_time=NULL, 
                     birth_rate_intercept=0, 
                     birth_rate_factor=0, birth_rate_exponent=1,
                     death_rate_intercept=0, 
                     death_rate_factor=0, death_rate_exponent=1,
                     coalescent=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{max_tips}{
Maximum number of tips of the tree to be generated. If \code{coalescent=TRUE}, this refers to the number of extant tips. Otherwise, it refers to the number of extinct + extant tips. If \code{NULL}, the number of tips is unlimited (so be careful).
}
\item{max_time}{
Maximum duration of the simulation.
}
\item{birth_rate_intercept}{
Non-negative number. The intercept of the Poissonian rate at which new species (tips) are added. In units 1/time.
}
\item{birth_rate_factor}{
Non-negative number. The power-law factor of the Poissonian rate at which new species (tips) are added. In units 1/time.
}
\item{birth_rate_exponent}{
Numeric. The power-law exponent of the Poissonian rate at which new species (tips) are added. Unitless.
}
\item{death_rate_intercept}{
Non-negative number. The intercept of the Poissonian rate at which extant species (tips) go extinct. In units 1/time.
}
\item{death_rate_factor}{
Non-negative number. The power-law factor of the Poissonian rate at which extant species (tips) go extinct. In units 1/time.
}
\item{death_rate_exponent}{
Numeric. The power-law exponent of the Poissonian rate at which extant species (tips) go extinct. Unitless.
}
\item{coalescent}{
Logical, specifying whether only the coalescent tree (i.e. the tree spanning the extant tips) should be returned. If \code{coalescent==FALSE} and the death rate is non-zero, then the tree may include non-extant tips (i.e. tips whose distance from the root is less than the total time of evolution). In that case, the tree will not be ultrametric.
}
}


\details{
If \code{max_time==NULL}, then the returned tree will always contain \code{max_tips} tips. In particular, if at any moment during the simulation the tree only includes a single extant tip, the death rate is temporarily set to zero to prevent the complete extinction of the tree. If \code{max_tips==NULL}, then the simulation is ran as long as specified by \code{max_time}. If neither \code{max_time} nor \code{max_tips} is \code{NULL}, then the simulation halts as soon as the time exceeds \code{max_time} or the number of tips (extant tips if \code{coalescent} is \code{TRUE}) exceeds \code{max_tips}.
}


\value{
A rooted bifurcating tree of class "phylo", generated according to the specified birth/death model. If \code{coalescent==TRUE} or if all death rates are zero, then the tree will be ultrametric.
}

\author{Stilianos Louca}

\references{
D. J. Aldous (2001). Stochastic models and descriptive statistics for phylogenetic trees, from Yule to today. Statistical Science. 16:23-34.

M. Steel and A. McKenzie (2001). Properties of phylogenetic trees generated by Yule-type speciation models. Mathematical Biosciences. 170:91-112.
}

%\seealso{
%}

\examples{
# Yule speciation model
tree = generate_random_tree(max_tips=100, birth_rate_intercept=1)

# Exponential growth rate model
tree = generate_random_tree(max_tips=100, birth_rate_factor=1)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
% Only 1 keyword per line
\keyword{random}
\keyword{speciation}
