% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-handlers.R
\name{beep_with}
\alias{beep_with}
\title{Play short sounds}
\usage{
beep_with(beepr_sound)
}
\arguments{
\item{beepr_sound}{A character string or number specifying the sound to be played. See the \code{sound} argument in \code{\link[beepr:beep]{beepr::beep()}} documentation.}
}
\description{
If you have the \link[beepr:beep]{beepr} package installed, catchr can use it to play sounds when certain conditions are being handled with \code{beep_with()}, similar to how \code{\link[=catchr-DSL]{beep}} works. But unlike \code{beep} and most catchr functions or special reserved terms, \code{beep_with()} is meant to be used as a user-defined function in a plan. It is particularly useful for when you're working with \code{futures} and busy doing something else while code is running in the background, or when you're working in a different window and want something to grab your attention.

\code{beep_with} can be used at the "top" level of a plan, since it returns a \emph{function} (which is required custom input for a catchr plan) that will play the beeping sound you've specified.
}
\examples{
warning_in_middle <- function() {
  message("It's time!")
  Sys.sleep(1)
  invisible("done")
}

if (requireNamespace("beepr", quietly = TRUE) == TRUE) {
  catch_expr(warning_in_middle(),
             message = c(beep_with(2), display, muffle))
  # Or you can just use the default sound with "beep":
  # catch_expr(warning_in_middle(), message = c(beep, display, muffle))
}
}
\seealso{
the \link{beep} special term, which will play the default beep; \code{\link[=user_exit]{user_exit()}} and \code{\link[=exit_with]{exit_with()}} for parallel functions for the \link{exit} special term, and \code{\link[=user_display]{user_display()}} and \code{\link[=display_with]{display_with()}} for parallel functions for the \link{display} special term.
}
