% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subject_schedule.R
\name{get_subject_schedule}
\alias{get_subject_schedule}
\title{Filter Course Schedule by Subject Code (Regex-Friendly)}
\usage{
get_subject_schedule(subject_pattern, schedule)
}
\arguments{
\item{subject_pattern}{A character string or regular expression to match subject codes.}

\item{schedule}{A data frame containing course schedule data with a \code{SUBJ} column.}
}
\value{
A filtered data frame containing only matching subject codes.
}
\description{
Returns a subset of the schedule where the \code{SUBJ} (subject code) column matches a given pattern.
Matching is case-insensitive and supports regular expressions.
}
\examples{
schedule <- data.frame(SUBJ = c("CSCI", "MATH", "STAT"))
get_subject_schedule("CSCI", schedule)
get_subject_schedule("^MATH|^STAT", schedule)

}
