% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-utilities.R
\name{graphrescheck}
\alias{graphrescheck}
\title{Check conditions on digraph}
\usage{
graphrescheck(graphres, ret = FALSE)
}
\arguments{
\item{graphres}{An \code{igraph} object representing a digraph.}

\item{ret}{A logical value. Default is \code{FALSE}.
Set to \code{TRUE} to also return \code{graphres} if all checks are passed.}
}
\value{
If \code{ret=FALSE} (default): \code{TRUE} if all checks pass; else \code{FALSE}.
If \code{ret=TRUE}: \code{graphres} if all checks pass; else \code{FALSE}.
}
\description{
Check that a given digraph satisfies the conditions of 
'no left to right edges', 'no cycles', 'valid number of categories' and 'valid variable names'.
Optionally returns the digraph if all checks are passed.
}
\examples{
graphres <- graph_from_literal(X -+ Y, X -+ M, M -+ Y, Ul -+ X, Ur -+ M, Ur -+ Y)
V(graphres)$leftside <- c(1, 0, 0, 1, 0)
V(graphres)$latent <- c(0, 0, 0, 1, 1)
V(graphres)$nvals <- c(2, 2, 2, 2, 2)
V(graphres)$exposure <- c(0, 0, 0, 0, 0)
V(graphres)$outcome <- c(0, 0, 0, 0, 0)
E(graphres)$rlconnect <- c(0, 0, 0, 0, 0, 0)
E(graphres)$edge.monotone <- c(0, 0, 0, 0, 0, 0)
graphrescheck(graphres = graphres) # TRUE
}
