% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTest.R
\name{permTest}
\alias{permTest}
\title{(Robust) permutation test for no association}
\usage{
permTest(x, y, R = 1000, fun = maxCorGrid, permutations = NULL,
  nCores = 1, cl = NULL, seed = NULL, ...)
}
\arguments{
\item{x, y}{each can be a numeric vector, matrix or data frame.}

\item{R}{an integer giving the number of random permutations to be used.}

\item{fun}{a function to compute a maximum correlation measure between
two data sets, e.g., \code{\link{maxCorGrid}} (the default) or
\code{\link{maxCorProj}}.  It should expect the data to be passed as the
first and second argument, and must return an object of class
\code{"maxCor"}.}

\item{permutations}{an integer matrix in which each column contains the
indices of a permutation.  If supplied, this is preferred over \code{R}.}

\item{nCores}{a positive integer giving the number of processor cores to be
used for parallel computing (the default is 1 for no parallelization).  If
this is set to \code{NA}, all available processor cores are used.}

\item{cl}{a \pkg{parallel} cluster for parallel computing as generated by
\code{\link[parallel]{makeCluster}}.  If supplied, this is preferred over
\code{nCores}.}

\item{seed}{optional integer giving the initial seed for the random number
generator (see \code{\link{.Random.seed}}).  For parallel computing, random
number streams are used rather than the standard random number generator and
the seed is set via \code{\link{clusterSetRNGStream}}.}

\item{\dots}{additional arguments to be passed to \code{fun}.}
}
\value{
An object of class \code{"permTest"} with the following components:
\item{pValue}{the \eqn{p}-value for the test.}
\item{cor0}{the value of the test statistic.}
\item{cor}{the values of the test statistic for each of the permutated data
sets.}
\item{R}{the number of random permutations.}
\item{seed}{the seed of the random number generator.}
\item{call}{the matched function call.}
}
\description{
Test whether or not there is association betwenn two data sets, with a focus
on robust and nonparametric correlation measures.
}
\details{
The test generates \code{R} data sets by randomly permuting the observations
of \code{x}, while keeping the observations of \code{y} fixed.  In each
replication, a function to compute a maximum correlation measure is
applied to the permuted data sets.  The \eqn{p}-value of the test is then
given by the percentage of replicates of the maximum correlation measure
that are larger than the maximum correlation measure computed from the
original data.
}
\examples{
data("diabetes")
x <- diabetes$x
y <- diabetes$y

## Spearman correlation
permTest(x, y, R = 100, method = "spearman")
permTest(x, y, R = 100, method = "spearman", consistent = TRUE)

## Pearson correlation
permTest(x, y, R = 100, method = "pearson")

}
\references{
A. Alfons, C. Croux and P. Filzmoser (2016) Robust maximum association
between data sets: The \R Package \pkg{ccaPP}.  \emph{Austrian Journal of
Statistics}, \bold{45}(1), 71--79.
}
\seealso{
\code{\link{maxCorGrid}}, \code{\link{maxCorProj}}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
\keyword{robust}
