% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R
\name{getResDiff.CFA}
\alias{getResDiff.CFA}
\title{getResDiff.CFA}
\usage{
getResDiff.CFA(cfaobj1, cfaobj2, fun, se = T, ...)
}
\arguments{
\item{cfaobj1}{the first CFA object}

\item{cfaobj2}{the second CFA object}

\item{fun}{a function to apply for every value of the treatment in the
cfaobj}

\item{se}{whether or not to compute standard errors}

\item{...}{can pass additional arguments to fun using this argument}
}
\value{
CFASE object
}
\description{
Get the difference between two CFA objects
}
\examples{
\dontrun{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)

## obtain counterfactual results
out <- cfa2(lcfincome ~ lfincome, tvals, yvals, igm, method1="qr",
xformla2=~HEDUC, method2="qr", iters=10, tau1=seq(.05,.95,.05),
tau2=seq(.05,.95,.05))

## get the difference between the average that adjusts for covariates and
## the one that does not
getResDiff.CFA(out$cfa1, out$cfa2, E)
}
}
