% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respiratory-condition.R
\name{resp_condition_fun1}
\alias{resp_condition_fun1}
\title{resp_condition_fun1}
\usage{
resp_condition_fun1(DHHGAGE_cont, CCC_091)
}
\arguments{
\item{DHHGAGE_cont}{continuous age variable.}

\item{CCC_091}{variable indicating if respondent has either COPD or Emphysema}
}
\value{
a categorical variable (resp_condition_der) with 3 levels:

 \enumerate{
 \item respondent is over the age of 35 and has a respiratory condition
 \item respondent is under the age of 35 and has a respiratory condition
 \item respondent does not have a respiratory condition
 }
}
\description{
This is one of 3 functions used to create a derived variable
 (resp_condition_der) that determines if a respondents has a respiratory
 condition. 3 different functions have been created to account for the fact
 that different respiratory variables are used across CCHS cycles. This
 function is for CCHS cycles (2009-2014) that only use COPD and Emphysema as
 a combined variable.
}
\examples{
# Using resp_condition_fun1() to create values across CCHS cycles
# (2009-2014) resp_condition_fun1() is specified in
# variable_details.csv along with the CCHS variables and cycles included.

# To transform resp_condition_der, use rec_with_table() for each CCHS cycle
# and specify resp_condition_der, along with the various respiratory
# variables. Then by using bind_rows() you can combine resp_condition_der
# across cycles.

library(cchsflow)

resp2010 <- rec_with_table(
  cchs2010,  c(
    "DHHGAGE_cont", "CCC_091",
    "resp_condition_der"
  )
)

head(resp2010)

resp2012 <- rec_with_table(
  cchs2012, c(
    "DHHGAGE_cont", "CCC_091",
    "resp_condition_der"
  )
)

tail(resp2012)

combined_resp <- bind_rows(resp2010, resp2012)

head(combined_resp)
tail(combined_resp)
}
\seealso{
\code{\link{resp_condition_fun2}}, \code{\link{resp_condition_fun3}}
}
