% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-hosp-data.r
\name{get_hosp_data}
\alias{get_hosp_data}
\title{Retrieves influenza hospitalization statistics from the CDC (deprecated)}
\usage{
get_hosp_data(
  area = "flusurvnet",
  age_group = "overall",
  years = as.numeric(format(Sys.Date(), "\%Y")) - 1
)
}
\arguments{
\item{area}{one of "\code{flusurvnet}", "\code{eip}", "\code{ihsp}", or two
digit state abbreviation for an individual site. Exceptions are
New York - Albany ("\code{nya}") and New York - Rochester
("\code{nyr}")}

\item{age_group}{a vector of age groups to pull data for. Possible values are:
"\code{overall}", "\code{0-4y}", "\code{5-17y}, "\code{18-49y},
"\code{50-64y}, "\code{65+y}".}

\item{years}{a vector of years to retrieve data for (i.e. \code{2014} for CDC
flu season 2014-2015). Default value is the current year and all
\code{years} values should be >= \code{2009}}
}
\value{
A single \code{data.frame}.
}
\description{
Uses the data source from the
\href{https://gis.cdc.gov/GRASP/Fluview/FluHospRates.html}{CDC FluView}
and provides influenza hospitalization reporting data as a data frame.
}
\note{
There is often a noticeable delay when making the API request to the CDC.
      This is not due to a large download size, but the time it takes for their
      servers to crunch the data. Wrap the function call in \code{httr::with_verbose}
      if you would like to see what's going on.
}
\examples{
\dontrun{
# All of FluSurv-NET, 50-64 years old, 2010/11-2014/15 flu seasons
hosp <- get_hosp_data("flusurvnet", "50-64y", years=2010:2014)
}
}
