% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{angleToDir}
\alias{angleToDir}
\title{Angle with a Reference Direction}
\usage{
angleToDir(x, dvec = c(1, 1, 1), from = 1, xdiff = diff(x), degrees = TRUE)
}
\arguments{
\item{x}{a single input track; a matrix whose first column is time and whose
remaining columns are a spatial coordinate.}

\item{dvec}{numeric vector specifying a reference direction to compute angles to.}

\item{from}{index, or vector of indices, of the first row of the track. If
\code{from} is a vector, angles are returned for all steps starting at
the indices in \code{from}.}

\item{xdiff}{row differences of x.}

\item{degrees}{logical; should angles be returned in degrees rather than radians? (default = TRUE).}
}
\value{
A single angle.
}
\description{
Compute the angle between the first step of a track and a reference direction.
Useful to detect biased movement when the directional bias is known (see examples).
}
\details{
The average angle of steps to a reference direction should be 90 degrees if there is
 no bias towards movement in the direction of the reference point. If there is such a bias,
 there should be an enrichment of smaller angles. The expected distribution without bias
 is a uniform distribution in 2D or a sine distribution in 3D (Beltman et al, 2009).
}
\examples{
## Get a distribution of Neutrophil step angles with the reference direction in positive
## y direction. The histogram is enriched for low angles, suggesting directed movement:
steps <- subtracks( Neutrophils, 1 )
hist( sapply( steps, angleToDir, dvec=c(0,1,0) ) )
}
\references{
Joost B. Beltman, Athanasius F.M. Maree and Rob. J. de Boer (2009),
Analysing immune cell migration. \emph{Nature Reviews Immunology} \bold{9},
789--798. doi:10.1038/nri2638
}
\seealso{
\code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
