% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.R
\name{get_state}
\alias{get_state}
\title{Extract the state of each individual at a given time}
\usage{
get_state(data, t, NAafterTmax = FALSE)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and
\code{state}, associated state.}

\item{t}{time at which extract the state}

\item{NAafterTmax}{if TRUE, return NA if t > Tmax otherwise return the state associated with Tmax
(useful when individuals has different lengths)}
}
\value{
a vector containing the state of each individual at time t
}
\description{
Extract the state of each individual at a given time
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)

# get the state of each individual at time t = 6
get_state(d_JK, 6)


# get the state of each individual at time t = 12 (> Tmax)
get_state(d_JK, 12)
# if NAafterTmax = TRUE, it will return NA for t > Tmax
get_state(d_JK, 12, NAafterTmax = TRUE)

}
\author{
Cristian Preda, Quentin Grimonprez
}
