% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretreatment.R
\name{cut_data}
\alias{cut_data}
\title{Cut data to a maximal given time}
\usage{
cut_data(data, Tmax)
}
\arguments{
\item{data}{data.frame containing \code{id}, id of the trajectory, \code{time}, time at which a change occurs and \code{state}, associated state.}

\item{Tmax}{max time considered}
}
\value{
a data.frame with the same format as \code{data} where each individual has \code{Tmax} as last time entry.
}
\description{
Cut data to a maximal given time
}
\examples{
# Simulate the Jukes-Cantor model of nucleotide replacement
K <- 4
PJK <- matrix(1 / 3, nrow = K, ncol = K) - diag(rep(1 / 3, K))
lambda_PJK <- c(1, 1, 1, 1)
d_JK <- generate_Markov(n = 10, K = K, P = PJK, lambda = lambda_PJK, Tmax = 10)
tail(d_JK)

# cut at Tmax = 8
d_JK2 <- cut_data(d_JK, Tmax = 8)
tail(d_JK2)
}
\author{
Cristian Preda
}
