% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphericalTriangle.R
\name{sphericalTriangle}
\alias{sphericalTriangle}
\title{Spherical triangle}
\usage{
sphericalTriangle(A, B, C, center = c(0, 0, 0), radius = 1, iterations = 4)
}
\arguments{
\item{A, B, C}{the three vertices of the triangle, each given either as a pair 
of numbers: the polar angle (between 0 and pi) and the azimuthal angle 
(between 0 and 2pi), or as Cartesian coordinates}

\item{center}{center of the sphere}

\item{radius}{radius of the sphere, ignored if the three vertices 
are given as Cartesian coordinates}

\item{iterations}{number of iterations used to construct the mesh of 
the sphere}
}
\value{
A \code{cgalMesh} object. The mesh has normals.
}
\description{
Mesh of a spherical triangle.
}
\examples{
library(cgalMeshes)
library(rgl)
# orthant
A <- c(0, pi/2)
B <- c(pi/2, pi/2)
C <- c(0, 0)
mesh <- sphericalTriangle(A, B, C)
rmesh <- mesh$getMesh()
open3d(windowRect = 50 + c(0, 0, 512, 512))
view3d(30, 30)
shade3d(rmesh, color = "red")
wire3d(rmesh)

# spherical icosahedron ####
library(cgalMeshes)
library(rgl)
icosahedron <- icosahedron3d()
vertices    <- icosahedron[["vb"]][-4L, ]
faces       <- icosahedron[["it"]]
colors <- rainbow(ncol(faces))
\donttest{open3d(windowRect = 50 + c(0, 0, 512, 512))
for(i in 1L:ncol(faces)) {
  triangle <- faces[, i]
  A <- vertices[, triangle[1L]]
  B <- vertices[, triangle[2L]]
  C <- vertices[, triangle[3L]]
  mesh <- sphericalTriangle(A, B, C)
  rmesh <- mesh$getMesh()
  shade3d(rmesh, color = colors[i])
  wire3d(rmesh)
}}
}
