% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgraph.R
\name{cg_val}
\alias{cg_val}
\title{Evaluate a Node in the Graph}
\arguments{
\item{name}{character scalar, name of the node that is evaluated.}
}
\value{
R object, the value of the node.
}
\description{
Evaluate node \code{name} in the graph.
}
\details{
\code{$val(name)}
}
\note{
The values of all nodes are cached for performance reasons. Only those nodes needed to compute node \code{name} and that have not yet been retrieved by \link[cgraph]{cg_val} are computed.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a parameter
a <- x$parm(20, name = "a")

# Evaluate a
x$val(a)

}
\author{
Ron Triepels
}
