% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{global_view}
\alias{global_view}
\alias{global_view_subplots}
\title{Linked \code{plotly} display, global view of data and attribution space.}
\usage{
global_view(
  cheem_ls,
  primary_obs = NULL,
  comparison_obs = NULL,
  color = c("default", "residual", "log_maha.data", "cor_attr_proj.y"),
  height_px = 480,
  width_px = 1440,
  as_ggplot = FALSE
)

global_view_subplots(
  cheem_ls,
  primary_obs = NULL,
  comparison_obs = NULL,
  color = c("default", "residual", "log_maha.data", "cor_attr_proj.y"),
  height_px = 480,
  width_px = 1440
)
}
\arguments{
\item{cheem_ls}{A return from \code{cheem_ls()}, a list of data frames.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line. Defaults to NULL, no highlighting applied.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line. Defaults to NULL, no highlighting applied.}

\item{color}{The name of the column in cheem_ls$global_view_df to map to
color. Expects c("default", "residual", "log_maha.data", "cor_attr_proj.y").
Defaults to "default"; predicted_class for classification, dummy class
for regression.}

\item{height_px}{The height in pixels of the returned \code{plotly} plot.
Defaults to 480.}

\item{width_px}{The width in pixels of the returned \code{plotly} plot.
Defaults to 1440.}

\item{as_ggplot}{Logical, if TRUE returns the plots before being passed to
\code{plotly} functions.}
}
\value{
A \code{plotly} plot, an interactive html widget of the global view,
first two components of the basis of the data- and attribution- spaces.
}
\description{
from a cheem_ls() list, create a linked \code{plotly} of the global data-
and attribution- spaces. Typically consumed directly by shiny app.
}
\examples{
library(cheem)

## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model, explanation, cheem list, global view:
rf_fit <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                     model = rf_fit,
                     attr_df = shap_df)

## Visualize
global_view(this_ls)                   ## uses ggplot facets \%>\% plotly
global_view(this_ls, as_ggplot = TRUE) ## early return of ggplot
global_view_subplots(this_ls)          ## uses plotly::subplots

## Different color mappings, especially for regression
\donttest{
global_view_subplots(this_ls, color = "residual")
global_view_subplots(this_ls, color = "log_maha.data") 
global_view_subplots(this_ls, color = "cor_attr_proj.y")
}
}
\seealso{
Other cheem consumers: 
\code{\link{radial_cheem_tour}()},
\code{\link{run_app}()}
}
\concept{cheem consumers}
