% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{sug_basis}
\alias{sug_basis}
\title{Suggest a 1D Basis}
\usage{
sug_basis(attr_df, rownum)
}
\arguments{
\item{attr_df}{A data frame of local explanation attributions.}

\item{rownum}{The rownumber of the observation.
Typically primary or comparison observations.}
}
\value{
A matrix of the 1D basis.
}
\description{
Extract and formats the 1D attribution basis from
the provided local explanation.
}
\examples{
library(cheem)

## Regression setup
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Attribution basis of one obs
sug_basis(ames_rf_shap, rownum = 1)
## This can be used to find a basis to start the radial tour.
# ?radial_cheem_tour
}
\seealso{
\code{\link[=radial_cheem_tour]{radial_cheem_tour()}}

Other cheem utility: 
\code{\link{as_logical_index}()},
\code{\link{color_scale_of}()},
\code{\link{contains_nonnumeric}()},
\code{\link{is_discrete}()},
\code{\link{is_diverging}()},
\code{\link{linear_tform}()},
\code{\link{logistic_tform}()},
\code{\link{problem_type}()},
\code{\link{rnorm_from}()},
\code{\link{sug_manip_var}()}
}
\concept{cheem utility}
