% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aet03.R
\docType{data}
\name{aet03_main}
\alias{aet03_main}
\alias{aet03_pre}
\alias{aet03_post}
\alias{aet03}
\title{\code{AET03} Table 1 (Default) Advert Events by Greatest Intensity Table 1.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
aet03_main(adam_db, arm_var = "ACTARM", lbl_overall = NULL, ...)

aet03_pre(adam_db, ...)

aet03_post(tlg, prune_0 = TRUE, ...)

aet03
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
An adverse events table categorized by System
Organ Class, Dictionary-Derived Term and Greatest intensity.
}
\details{
\itemize{
\item Default Adverse Events by Greatest Intensity table.
\item Numbers represent absolute numbers of patients and fraction of \code{N}.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Sort by Body System or Organ Class (\code{SOC}) and Dictionary-Derived Term (\code{PT}).
}
}
\section{Functions}{
\itemize{
\item \code{aet03_main()}: Main TLG function

\item \code{aet03_pre()}: Preprocessing

\item \code{aet03_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adae} table with the columns \code{"AEBODSYS"}, \code{"AEDECOD"} and \code{"ASEV"}.
}
}
\examples{
run(aet03, syn_data)
}
\keyword{datasets}
