% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmt02_pt.R
\docType{data}
\name{cmt02_pt_main}
\alias{cmt02_pt_main}
\alias{cmt02_pt_pre}
\alias{cmt02_pt_post}
\alias{cmt02_pt}
\title{\code{CMT02_PT} Table 1 (Default) Concomitant Medications by Preferred Name.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
cmt02_pt_main(
  adam_db,
  arm_var = "ARM",
  lbl_overall = NULL,
  row_split_var = NULL,
  medname_var = "CMDECOD",
  summary_labels = list(TOTAL = cmt01_label),
  ...
)

cmt02_pt_pre(adam_db, ...)

cmt02_pt_post(
  tlg,
  prune_0 = TRUE,
  sort_by_freq = FALSE,
  row_split_var = NULL,
  medname_var = "CMDECOD",
  ...
)

cmt02_pt
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{row_split_var}{(\code{character}) the variable defining the medication category. By default \code{ATC2}.}

\item{medname_var}{(\code{string}) variable name of medical treatment name.}

\item{summary_labels}{(\code{list}) of summarize labels. See details.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}

\item{sort_by_freq}{(\code{flag}) whether to sort medication class by frequency.}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
A concomitant medication table with the
number of subjects and the total number of treatments by medication name sorted by frequencies.
}
\details{
\itemize{
\item Data should be filtered for concomitant medication. \code{(ATIREL == "CONCOMITANT")}.
\item Numbers represent absolute numbers of subjects and fraction of \code{N}, or absolute numbers when specified.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Sort by medication class alphabetically and within medication class by decreasing total number of patients with
the specific medication.
\code{summary_labels} is used to control the summary for each level. If "all" is used, then each split will have that
summary statistic with the labels. One special case is "TOTAL", this is for the overall population.
}
}
\section{Functions}{
\itemize{
\item \code{cmt02_pt_main()}: Main TLG function

\item \code{cmt02_pt_pre()}: Preprocessing

\item \code{cmt02_pt_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adcm} table with the columns specified in \code{row_split_var} and \code{medname_var}
as well as \code{"CMSEQ"}.
}
}
\examples{
run(cmt02_pt, syn_data)
}
\keyword{datasets}
