% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxt02.R
\docType{data}
\name{coxt02_main}
\alias{coxt02_main}
\alias{coxt02}
\title{\code{COXT02} Multi-Variable Cox Regression Model Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
coxt02_main(
  adam_db,
  arm_var = "ARM",
  time_var = "AVAL",
  event_var = "EVENT",
  covariates = c("SEX", "RACE", "AAGE"),
  strata = NULL,
  lbl_vars = "Effect/Covariate Included in the Model",
  multivar = TRUE,
  ...
)

coxt02
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) the arm variable used for arm splitting.}

\item{time_var}{(\code{string}) the time variable in a Cox proportional hazards regression model.}

\item{event_var}{(\code{string}) the event variable in a Cox proportional hazards regression model.}

\item{covariates}{(\code{character}) will be fitted and the corresponding effect will be estimated.}

\item{strata}{(\code{character}) will be fitted for the stratified analysis.}

\item{lbl_vars}{(\code{string}) text label for the a Cox regression model variables.}

\item{multivar}{(\code{flag}) indicator of whether multivariate cox regression is conducted.}

\item{...}{Further arguments passed to \code{tern::control_coxreg()}.}
}
\value{
the main function returns an \code{rtables} object.
}
\description{
The \code{COXT02} table follows the same principles as the general Cox model analysis
and produces the estimates for each of the covariates included in the model
(usually the main effects without interaction terms).
}
\details{
\itemize{
\item The reference arm will always the first level of \code{arm_var}. Please change the level if you want to
change the reference arms.
\item The table allows confidence level to be adjusted, default is two-sided 95\%.
\item The stratified analysis is with DISCRETE tie handling (equivalent to \code{tern::control_coxreg(ties = "exact")} in R).
\item Model includes treatment plus specified covariate(s) as factor(s) or numeric(s),
with \code{"SEX"}, \code{"RACE"} and \code{"AAGE"} as default candidates.
\item The selection of the covariates and whether or not there is a selection process
(vs. a fixed, pre-specified list) needs to be pre-specified.
\item For pairwise comparisons using the hazard ratio, the value for the control group is the denominator.
\item Keep zero-count rows unless overridden with \code{prune_0 = TRUE}.
}
}
\section{Functions}{
\itemize{
\item \code{coxt02_main()}: Main TLG function

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adtte} table with \code{"PARAMCD"}, \code{"ARM"},
\code{"AVAL"}, \verb{"CNSR}, and the columns specified by \code{"covariates"} which is denoted as
\code{c("SEX", "RACE", "AAGE")} by default.
}
}
\examples{
library(dunlin)

proc_data <- log_filter(syn_data, PARAMCD == "CRSD", "adtte")

run(coxt02, proc_data)

run(coxt02, proc_data, covariates = c("SEX", "AAGE"), strata = c("RACE"), conf_level = 0.90)
}
\keyword{datasets}
