% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nystrom_kernel_parallel.R
\name{Nystrom_kernel}
\alias{Nystrom_kernel}
\title{Nystrom kernel approximation}
\usage{
Nystrom_kernel(
  Data,
  c,
  l,
  s,
  gamma = NULL,
  max_neighbors = 32,
  DIR_output = tempfile(),
  DIR_save = tempfile(),
  ncores = 2,
  ncores_svd = 1,
  distance_type = "W1",
  kernel_type = "Gaussian",
  verbose = FALSE
)
}
\arguments{
\item{Data}{A Filebacked Big Matrix n x N. Data vectors are stored in the matrix columns.}

\item{c}{Number of columns selected for the approximation.}

\item{l}{An intermediate rank l < c.}

\item{s}{A target rank s < l.}

\item{gamma}{Kernel parameter. If it is NULL (default), the parameter is estimated using \code{\link{gamma_estimation}}.}

\item{max_neighbors}{Number of neigbors selected for the paramenter estimation.}

\item{DIR_output}{A directory for intermediate computations.}

\item{DIR_save}{A directory to save the result.}

\item{ncores}{Number of cores. Default is 2.}

\item{ncores_svd}{Number of cores used for the SVD computaion. It is recommended to use 1 core (default).}

\item{distance_type}{Distance function type. The available types are Wasserstein-1 ('W1') and Euclidean ('Euclide').
The default value is 'W1'.}

\item{kernel_type}{Kernel function type c('Gaussian', 'Laplacian').}

\item{verbose}{logical that indicates whether dysplay the processing steps.}
}
\value{
A list with the following attributes: \itemize{
\item \code{K_W1} is the Filebacked Big Matrix of the Nystrom kernel approximation.
\item \code{gamma} is the estimated kernel parameter.
\item \code{RandomSample} is the data vector indices, selected for the Nystrom approximation. }
}
\description{
An implementation of the Nystrom kernel approximation method.
}
\details{
Nystrom method consists in approximating the kernel matrix \eqn{K} by \eqn{ C W^{-1} C^{\top}}, with
\eqn{C \in R^{N \times c}} obtained from \eqn{K} by randomly selecting only \code{c} columns and
\eqn{W \in R^{c \times c}} obtained from \eqn{C} by selecting as well \code{c} corresponding rows.
The kernel function, based on the distance metric, is given as follows: \eqn{k(x_i,x_j) = e^{- gamma \cdot d^p(x_i,x_j)}},
where \eqn{p} is equal to 1 for 'Laplacian' kernel and equal to 2 for 'Gaussian' kernel and
where \eqn{d(x_i,x_j)} is the distance between data vectors \eqn{x_i} and \eqn{x_j}.
}
\note{
This is an implemetation of the Nystrom kernel approximation method proposed in
\insertRef{wang2019scalable}{chickn}.
}
\examples{
\donttest{
X = matrix(rnorm(2000), ncol=100, nrow = 20)
X_FBM = bigstatsr::FBM(init = X, ncol=100, nrow = 20)

output = Nystrom_kernel(Data = X_FBM, c = 10, l = 7, s = 5, 
                        max_neighbors = 3, ncores = 2)
                        }
}
\seealso{
\code{\link{W1_parallel}}, \code{\link{gamma_estimation}}, \code{\link[bigstatsr]{big_randomSVD}}, \code{\link{cumsum_parallel}}.
}
