% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createlms.R
\name{prepare_data}
\alias{prepare_data}
\title{prepare data for iteration process}
\usage{
prepare_data(data, group = NULL, subject = "SIC", sex = NULL,
  value = "value", age = "age", lb = -Inf, ub = Inf)
}
\arguments{
\item{data}{dataframe containing measurement values, age, sex, and subject identifier}

\item{group}{optional variable indicating groups of subjects within the data frame in most cases (families)}

\item{subject}{subject identifier}

\item{sex}{column containing the sex (or any other stratum), ideally of type character, iteration process will run on each of the levels separately}

\item{value}{numeric column containing the measurement values}

\item{age}{numeric column containing the age}

\item{lb}{optional - lower bound for age}

\item{ub}{optional - upper bound for age}
}
\value{
list of dataframes containing the columns group, subject, sex, age, value; one dataframe for every level of sex
}
\description{
prepare data for repeated iteration process
}
\details{
given a dataframe, the column name of the subject identifier, sex, age,
value and group colums, the function creates a dataframe containing only
these five columns with the standard column names group, subject, sex, age, value.
lines containing missing values are removed.
}
\author{
Mandy Vogel
}
